#pragma once
#include <fstream>   
#include <vector>

#define PRINT_STB_OBJECT_SEPERATELY // not used in console
#define ELF_FUNC_OK 0
// Error returns
#ifndef ELF_ERROR_START
	#define ELF_ERROR_START -40
#endif
#define ERROR_ELF_OPEN  ELF_ERROR_START-1 //could not open elf file
#define ERROR_ELF_STRING_TABLE_NOT_FOUND ELF_ERROR_START -2	// could not find string table
#define ERROR_ELF_BASIC_FILE_CREATE ELF_ERROR_START-3	// could not create the basic file
#define ERROR_ELF_C_FILE_OPEN ELF_ERROR_START-4 // could not open C file
#define ERROR_ELF_HDR_BYTES ELF_ERROR_START-5 // File Header read bytes Incorrect
#define ERROR_ELF_SECTION_HDR_SIZE ELF_ERROR_START-6 // File Section Header Size Incorrect
#define ERROR_ELF_SECTION_HDR_READ ELF_ERROR_START-7 //  Section Header bytes read incorrect
#define ERROR_ELF_SYMB_TABLE_READ ELF_ERROR_START-8 // Symbol Table bytes read incorrect
#define ERROR_ELF_NOT_ELF_FILE ELF_ERROR_START-9 //Not a correct ELF file as not 'ELF' word found
#define ERROR_TIME_STRUCT_FILL ELF_ERROR_START-10 // could not fill time structure for some reason
#define ERROR_TIME_ASC_CONVERT ELF_ERROR_START-11 // coud not convert time to ascii
#define ERROR_JOIN_CONST_DATA ELF_ERROR_START-12 // found static const data in JOIN type

#define MAX_CODE_BYTES 0xFFFFF // 1Mbytes is max size of code
#define CMM2_TYPE 1 
#define MMPLUS_TYPE 2 
#define MERGE_TYPE 1
#define JOIN_TYPE 2
#define CFUNC_TYPE 1
#define CSUB_TYPE 2

#define SHT_TYPE_PROGBITS 1
#define SHT_TYPE_SYMTAB  2
#define SHT_STRTAB 3
#define SHT_TYPE_SHT_NOBITS 8

#define SHT_ATTRIBUTES_ALLOC 2
#define SHT_ATTRIBUTES_EXECINSTR 4
#define TEXT_ATTRIBUTE 6 // SHT_ATTRIBUTES_ALLOC | SHT_ATTRIBUTES_EXECINSTR
#define DINIT_ATTRIBUTE 0x10000006 // TEXT_ATTRIBUTE | 10000000
#define SHT_ATTRIBUTES_SHF_WRITE 1
#define SHT_ATTRIB_BSS 3 // SHT_ATTRIBUTES_SHF_WRITE | SHT_ATTRIBUTES_ALLOC
#define STT_SECTION 3
#define STB_OBJECT 1 // variable, array etc
#define STB_GLOBAL 0x10
#define STT_FUNC 2 // a function
//#define VALID_FUNCTION STB_GLOBAL | STT_FUNC
#define LOCAL_AND_FUNCTION 0x02 // exclude
#define STT_SECTION 3

#define CFUNC_CMD_BYTES_LENGTH 4



#ifndef BASIC_FILE_APPEND
#define BASIC_FILE_APPEND L"_CSUB.bas" //whats added to the end of the C File or ELF name for the Basic CFunc or CSub
#endif
#ifndef WS_NOT_SET
#define WS_NOT_SET L"Not Set"
#endif

#define EI_NIDENT 16 // number of chars
#define ELF_32_HEADER_SIZE 52 //bytes

typedef UINT32 Elf32_Addr;
typedef UINT16 Elf32_Half;
typedef UINT32 Elf32_Off;
typedef INT32 Elf32_Sword;
typedef UINT32 Elf32_Word;

struct Elf32_Ehdr {
	UCHAR e_ident[EI_NIDENT];
	Elf32_Half e_type;
	Elf32_Half e_machine;
	Elf32_Word e_version;
	Elf32_Addr e_entry;
	Elf32_Off e_phoff;
	Elf32_Off e_shoff;
	Elf32_Word e_flags;
	Elf32_Half e_ehsize;
	Elf32_Half e_phentsize;
	Elf32_Half e_phnum;
	Elf32_Half e_shentsize;
	Elf32_Half e_shnum;
	Elf32_Half e_shstrndx;
};

#define ELF_32_SECTION_HEADER_SIZE 40 // 10 x 4 bytes

struct Elf32_Shdr {
	Elf32_Word sh_name;
	Elf32_Word sh_type;
	Elf32_Word sh_flags;
	Elf32_Addr sh_addr;
	Elf32_Off sh_offset;
	Elf32_Word sh_size;
	Elf32_Word sh_link;
	Elf32_Word sh_info;
	Elf32_Word sh_addalign;
	Elf32_Word sh_entsize;
};

#define ELF_32_SYMBOL_TABLE_ENTRY_SIZE 16 // 3 x 4 + 2 X 1 + 2 bytes
struct Elf32_Sym {
	Elf32_Word st_name;
	Elf32_Addr st_value;
	Elf32_Word st_size;
	unsigned char st_info;
	unsigned char st_other;
	Elf32_Half st_shndx;
	std::wstring st_wsName;
};

struct FuncData {
	std::wstring m_csName; // text name
	int m_CodeStringParamLoc{}; // where format for the call would go
	int m_nSymbolTableIndex{};
};

class CElfToCSub
{
protected:
	std::wstring m_wsELFFilePath; 
	std::wstring m_wsMergeName; 
	std::wstring m_wsCFilePath; // what the c function resides in
	int m_MergeJoinType; // Merge or Join
	int m_nSubFuncType; // CSub or CFunction
	std::ifstream m_ELFFile;
	Elf32_Ehdr m_ELF_Header;
	std::vector<Elf32_Shdr> m_SectionVector;
	std::vector<Elf32_Sym> m_SymbolTableVector;
	std::vector<Elf32_Sym> m_CRoutineSymbolTableVector;// only those that matter
	//std::vector<Elf32_Sym> m_CRodataSymbolTableVector;
	//std::vector<Elf32_Sym> m_CDinitSymbolTableVector;
	std::vector<FuncData> m_FunctionDataVector;
	Elf32_Sym m_DebugSymItem; // debug only
	Elf32_Addr m_nTextAdd;
	Elf32_Word m_nTextSize;
	Elf32_Addr m_nRodataAdd;
	Elf32_Word m_nRodataSize;
	Elf32_Addr m_nDinitAdd;
	Elf32_Word m_nDinitSize;
	Elf32_Word m_nBSSSize{};
	Elf32_Addr m_nMainAddress;
	UINT32 m_nMainJmp; // for merge jump to main
	UINT m_nSymbolTableEntries;
	int m_nStrTabIndex{}; // what section is the string table
	//int m_nSymbTabIndex{}; // what section is the symbol table
	int m_nTextSectionIndex{}; //what section .text data stored
	int m_nRodataSectionIndex{};
	int m_nDinitSectionIndex{};
	int m_nMainParamInsertIndex{};
	int m_nCCode4ByteCnt{};
	int m_nELFType{}; // MM+ or CMM2
	std::wstring m_wsELEProcessorType; // string version
	
	void CopyToClipboard(std::wstring cs);
	std::wstring RemoveCodeComments(const std::wstring& csLineIn);
	std::wstring GetFullParamLine(std::wifstream* inFile, std::wstring& wsline);
	std::wstring ExtractVariableType(const std::wstring& svariable);
	std::wstring CreateParsedParamFormat(const std::wstring& csline, const std::wstring& name);
	bool VoidFuncVoid(const std::wstring& sline, const std::wstring& name);
	int SetCallFormat();
	void CreateMergeText();
	void CreateJoinText(const int ELFType,  const std::vector<Elf32_Sym>::iterator& it);

public:
	CElfToCSub(const std::wstring& ELFFile, const std::wstring& Mergename, const std::wstring& CProgFile =L"", 
			const int CMergeJoinType = MERGE_TYPE, const int CFuncSubType = CSUB_TYPE);
	~CElfToCSub();
	std::wstring m_wstrCode;
	std::wstring m_wsBASICFilePath; // BASIC file path
	std::wstring m_wsBASICFileName;
	std::wstring m_wsFunctionInfo; // address and size of functions
	bool m_bMainNot32bitBoundary{ false };
	long CreateCFunctions();
	int Load_ELFFile();
	void SetFuncSubType(const int type) { m_nSubFuncType = type; };
	int FuncSubType(const int type) { return m_nSubFuncType; };
	std::wstring wsELfProcessorType(){ return  m_wsELEProcessorType; };
	int nELfProcessorType() { return  m_nELFType; };
	std::wstring BSSSize();
	std::wstring TextSize();
	void ClearCSourcePath() { m_wsCFilePath.clear(); };
};

